from flask import Flask, request
from flask_cors import CORS
import random

# List of words to choose from for the password
word_list = [line.strip() for line in open("kotus-sanalista_lyhyt.csv")]
sep = ["1", "2", "3", "4", "5", "6",
      "7", "8", "9", "0", "!", "?",
      "%", "&", "#", ".", "'"]

def generate_password(nwords):
    """Generates a password with a specified number of words."""
    if nwords <= 0:
        return "Please enter a positive number of words."
    
    password_parts = []
    for _ in range(nwords):
        password_parts.append(random.choice(word_list))
        password_parts.append(random.choice(sep))
    
    return "".join(password_parts)

app = Flask(__name__)
CORS(app)

@app.route("/gen")
def api_generate_password():
    """API endpoint to generate a password."""
    nwords = request.args.get('nwords', default=2, type=int)
    
    pw = generate_password(nwords)
    
    return pw
